(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     64273,       1726]
NotebookOptionsPosition[     55471,       1601]
NotebookOutlinePosition[     55976,       1620]
CellTagsIndexPosition[     55933,       1617]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Derivations for state-symmetric generators", "Subtitle",
 CellChangeTimes->{{3.8551180865139246`*^9, 
  3.8551180932936788`*^9}},ExpressionUUID->"18dee504-3c88-454d-ba0e-\
aac5e649336b"],

Cell["Note: This computation is supposed to take 15-30 minutes.", "Text",
 CellChangeTimes->{{3.8551428214483275`*^9, 
  3.855142848211979*^9}},ExpressionUUID->"e02fb853-9fcd-4f3a-b335-\
6b2525cab164"],

Cell[CellGroupData[{

Cell["Auxiliary definitions", "Subsection",
 CellChangeTimes->{{3.8551181065893307`*^9, 
  3.8551181119335427`*^9}},ExpressionUUID->"f3ffe692-ec71-4f9d-a372-\
9b7b78d5a6f3"],

Cell["Abbreviation for the identity matrix", "Text",
 CellChangeTimes->{{3.855118130420493*^9, 
  3.8551181406683135`*^9}},ExpressionUUID->"d4f1eecf-e9d7-42f8-b3ea-\
033e8677efa5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Id", "[", "n_", "]"}], ":=", 
   RowBox[{"IdentityMatrix", "[", "n", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"487ea45d-740b-424b-894e-05ba763424af"],

Cell["Abbreviation for the commutator", "Text",
 CellChangeTimes->{{3.8551181493888435`*^9, 
  3.855118157645566*^9}},ExpressionUUID->"6bb6a308-7e02-43c4-bd10-\
1ff2372e73b3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Com", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"a", ".", "b"}], "-", 
    RowBox[{"b", ".", "a"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"cbf9c7cd-e94e-4f8f-98fb-3ff1ca72da63"],

Cell["Abbreviation for the adjoint", "Text",
 CellChangeTimes->{{3.8551181688453608`*^9, 
  3.855118174061526*^9}},ExpressionUUID->"4458f5f6-4213-4e2c-9548-\
4ef1b76e3a4f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CT", "[", "x_", "]"}], ":=", 
   RowBox[{"ConjugateTranspose", "[", "x", "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"7e26f595-1fd5-488c-8c69-0b86d7305957"],

Cell["The normalised trace", "Text",
 CellChangeTimes->{{3.855118190927495*^9, 
  3.8551181990684614`*^9}},ExpressionUUID->"09b14602-1d1d-478e-b2ff-\
55790d1c215c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nTr", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Tr", "[", "x", "]"}], "/", "3"}]}], ";"}]], "Input",
 CellChangeTimes->{3.8551417472015467`*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"44417259-50eb-4f15-ab64-65b781667c74"],

Cell["A few general 3x3 matrices", "Text",
 CellChangeTimes->{{3.855119870083488*^9, 3.8551198747073727`*^9}, {
  3.8551417491866145`*^9, 
  3.8551417504328413`*^9}},ExpressionUUID->"f4acf89f-d229-45df-8028-\
b4b3c6f05cd9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"genmatc", "=", 
   RowBox[{"Array", "[", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"genmatd", "=", 
   RowBox[{"Array", "[", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.8520921709985723`*^9, 3.85209220241722*^9, {3.8551198869972353`*^9, 
   3.855119887874594*^9}, {3.855141751807686*^9, 3.8551417560647187`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"15c805d5-9f22-48e8-aeaa-eec79daafa99"],

Cell["\<\
A general self-adjoint matrix (if all variables in it are real). This matrix \
will form the inner product, and we will solve the system of linear equations \
mentioned in the paper for this matrix.\
\>", "Text",
 CellChangeTimes->{{3.85511823785296*^9, 
  3.855118323453656*^9}},ExpressionUUID->"5066d5db-e14c-44f9-89a5-\
c36a017ac4c7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"HSinprmatr", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"dr", "[", 
               RowBox[{"i", ",", "j"}], "]"}], "+", 
              RowBox[{"I", " ", 
               RowBox[{"di", "[", 
                RowBox[{"i", ",", "j"}], "]"}]}]}], ",", 
             RowBox[{"i", ">", "j"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"dr", "[", 
               RowBox[{"j", ",", "i"}], "]"}], "-", 
              RowBox[{"I", " ", 
               RowBox[{"di", "[", 
                RowBox[{"j", ",", "i"}], "]"}]}]}], ",", 
             RowBox[{"j", ">", "i"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"dr", "[", 
          RowBox[{"i", ",", "i"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "81"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "81"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8511567909208813`*^9, 3.8511568148813963`*^9}, 
   3.8511603438282366`*^9, {3.8520922263474436`*^9, 3.852092232114159*^9}, {
   3.8551183365104513`*^9, 3.8551183366216087`*^9}, {3.855118490189539*^9, 
   3.855118496606782*^9}, {3.855141761511058*^9, 3.8551417862017775`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"0d8cb758-558f-498b-a0c6-c821a5169e8a"],

Cell[TextData[{
 "The variables that are contained in ",
 StyleBox["HSinprmatr", "Input"],
 "."
}], "Text",
 CellChangeTimes->{{3.855118389997505*^9, 3.8551184060444727`*^9}, {
  3.85511849943778*^9, 
  3.8551185027810097`*^9}},ExpressionUUID->"b0d17b38-0702-4b4e-8241-\
8040240d3690"],

Cell[BoxData[
 RowBox[{
  RowBox[{"HSinprvars", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"dr", "[", 
             RowBox[{"j", ",", "i"}], "]"}], ",", 
            RowBox[{"di", "[", 
             RowBox[{"j", ",", "i"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"i", "+", "1"}], ",", "81"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "81"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"dr", "[", 
        RowBox[{"i", ",", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "81"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.851159896272621*^9, 3.851159896924963*^9}, 
   3.8551184316768675`*^9, {3.855118493133545*^9, 3.8551184978215528`*^9}, {
   3.855141768946451*^9, 3.855141781724815*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"0b0eed15-9c03-46f3-b867-6451b58b3135"],

Cell["The basis for the 3x3 matrices", "Text",
 CellChangeTimes->{{3.8551184366844716`*^9, 3.8551184425726995`*^9}, {
  3.8551417904954367`*^9, 
  3.85514179118118*^9}},ExpressionUUID->"a922e8cd-dfdf-48c6-95a7-\
6e5d15918e6b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"matrbasis", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"ArrayReshape", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "&"}], "/@", 
    RowBox[{"Id", "[", "9", "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{3.855141798324686*^9},
 CellLabel->"In[9]:=",ExpressionUUID->"a2e0ca3e-406c-4e79-914e-e1f12746ded2"],

Cell["\<\
The basis for the Hilbert space that is the codomain of the derivation\
\>", "Text",
 CellChangeTimes->{{3.8551184644129314`*^9, 
  3.85511847966177*^9}},ExpressionUUID->"acc02c3b-6284-4797-b3c0-\
ec0f9ca75654"],

Cell[BoxData[
 RowBox[{
  RowBox[{"HSbasis", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Outer", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"KroneckerProduct", "[", 
             RowBox[{"#1", ",", "#2"}], "]"}], "//", "Flatten"}], "}"}], "//",
           "Transpose"}], ")"}], "&"}], ",", "matrbasis", ",", "matrbasis", 
       ",", "1"}], "]"}], ",", "1"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8511568592322025`*^9, 3.851156859353622*^9}, {
  3.855118520016252*^9, 3.855118521373946*^9}, {3.855141810349035*^9, 
  3.855141814896694*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"3bdbc3ba-21b0-4688-a3b2-8ef94a67d56e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Definition of the left multiplication", "Subsection",
 CellChangeTimes->{{3.85511934455542*^9, 
  3.8551193508428297`*^9}},ExpressionUUID->"1aed2868-64d9-4323-9550-\
36da5574f1e3"],

Cell["\<\
The aim is to be able to find the bounded operator on the Hilbert space that \
corresponds to left multiplication by a matrix C. This bounded operator takes \
the form of a matrix with respect to the standard basis. We will find this \
matrix by writing down a system of linear equations that it must satisfy, and \
then solving this system of equations.\
\>", "Text",
 CellChangeTimes->{{3.8551193655243025`*^9, 
  3.855119528844592*^9}},ExpressionUUID->"43663ee0-dffb-4bb4-8a8f-\
6c9ab698115f"],

Cell[TextData[{
 "The options that are needed to check that the left multiplication matrix \
acts correctly. In other words: ",
 StyleBox["#1", "Input"],
 " and ",
 StyleBox["#2", "Input"],
 " play the role of A and B in A\[TensorProduct]B, and for every combination \
in ",
 StyleBox["LMoptions", "Input"],
 " we require that the left multiplication matrix acts as expected."
}], "Text",
 CellChangeTimes->{{3.8551195659000454`*^9, 
  3.855119683462344*^9}},ExpressionUUID->"ca957107-5c31-4b70-b227-\
2ab3e6b349e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LMoptions", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Outer", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2"}], "}"}], "&"}], ",", "matrbasis", ",", 
       "matrbasis", ",", "1"}], "]"}], ",", "1"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851156997207614*^9, 3.8511570041948023`*^9}, 
   3.855119710301996*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"210cd4f0-f685-4816-b4ec-b1ee8c36a310"],

Cell["\<\
The general matrix that acts as the left multiplication. We will solve the \
system of equations for this matrix. \
\>", "Text",
 CellChangeTimes->{{3.8551197493701153`*^9, 
  3.855119802516252*^9}},ExpressionUUID->"2f430c0d-0ed9-4336-a1b6-\
bf5e89e09863"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LMmatr", "=", 
   RowBox[{"Array", "[", 
    RowBox[{"l", ",", 
     RowBox[{"{", 
      RowBox[{"81", ",", "81"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851157563935605*^9, 3.8511575641035213`*^9}, 
   3.8551198140192633`*^9, {3.855141825843179*^9, 3.85514182935947*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"bbf4e3df-9847-4ed1-809b-bfdf8622dfab"],

Cell[TextData[{
 "The equations that ",
 StyleBox["LMmatr", "Input"],
 " must satisfy."
}], "Text",
 CellChangeTimes->{{3.855119818198496*^9, 
  3.855119830020871*^9}},ExpressionUUID->"3409362d-ddfe-48bd-ac18-\
c2a5c45192ec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LMeqs", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"KroneckerProduct", "[", 
             RowBox[{
              RowBox[{"genmatc", ".", 
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "-", 
            RowBox[{"KroneckerProduct", "[", 
             RowBox[{"genmatc", ",", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ".", 
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], ")"}], "//", 
          "Flatten"}], ")"}], "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"LMmatr", ".", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"KroneckerProduct", "[", 
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "//", "Flatten"}],
                "}"}], "//", "Transpose"}], ")"}]}], ")"}], "//", "Flatten"}],
          ")"}]}], "==", "0"}], ")"}], "&"}], "/@", "LMoptions"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8511576530711184`*^9, 3.8511576624787693`*^9}, 
   3.8551198457891626`*^9, {3.85511989555723*^9, 3.855119899832492*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"ee8fbcf6-c7f5-4ad0-ad05-a60396047180"],

Cell[TextData[{
 "Now we solve the system of linear equations to express ",
 StyleBox["LMmatr", "Input"],
 " in terms of ",
 StyleBox["genmatc", "Input"],
 "."
}], "Text",
 CellChangeTimes->{{3.8551199082052803`*^9, 
  3.855119953221135*^9}},ExpressionUUID->"703e9b07-80a3-4e78-9a6a-\
07a8a3fe70a4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LMans", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{"LMeqs", ",", 
     RowBox[{"LMmatr", "//", "Flatten"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LMmatrSol", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"LMmatr", "/.", "LMans"}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8511577351622133`*^9, 3.851157748168078*^9}, {
   3.851157786524358*^9, 3.851157796788237*^9}, 3.852093972930359*^9, {
   3.855119975380973*^9, 3.8551199943279514`*^9}, {3.855133686861991*^9, 
   3.855133688527072*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"402e35fe-a44a-4c40-81d2-9d3a0ec43db8"],

Cell[TextData[{
 "We can now use this matrix, ",
 StyleBox["LMmatrSol", "Input"],
 ", to define the left multiplication."
}], "Text",
 CellChangeTimes->{{3.8551200016352673`*^9, 
  3.855120023059656*^9}},ExpressionUUID->"55e86c29-d85e-48ca-ba1b-\
1b6592d65650"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LM", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a11_", ",", "a12_", ",", "a13_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a21_", ",", "a22_", ",", "a23_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a31_", ",", "a32_", ",", "a33_"}], "}"}]}], "}"}], ",", 
     "vec_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"LMmatrSol", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"c", "[", 
          RowBox[{"1", ",", "1"}], "]"}], "->", "a11"}], ",", 
        RowBox[{
         RowBox[{"c", "[", 
          RowBox[{"1", ",", "2"}], "]"}], "->", "a12"}], ",", 
        RowBox[{
         RowBox[{"c", "[", 
          RowBox[{"1", ",", "3"}], "]"}], "->", "a13"}], ",", 
        RowBox[{
         RowBox[{"c", "[", 
          RowBox[{"2", ",", "1"}], "]"}], "->", "a21"}], ",", 
        RowBox[{
         RowBox[{"c", "[", 
          RowBox[{"2", ",", "2"}], "]"}], "->", "a22"}], ",", 
        RowBox[{
         RowBox[{"c", "[", 
          RowBox[{"2", ",", "3"}], "]"}], "->", "a23"}], ",", 
        RowBox[{
         RowBox[{"c", "[", 
          RowBox[{"3", ",", "1"}], "]"}], "->", "a31"}], ",", 
        RowBox[{
         RowBox[{"c", "[", 
          RowBox[{"3", ",", "2"}], "]"}], "->", "a32"}], ",", 
        RowBox[{
         RowBox[{"c", "[", 
          RowBox[{"3", ",", "3"}], "]"}], "->", "a33"}]}], "}"}]}], ")"}], 
    ".", "vec"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851157888053591*^9, 3.851157898599275*^9}, {
  3.855120030166478*^9, 3.855120036600398*^9}, {3.8551418489761457`*^9, 
  3.855141857911521*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"2b97d8a5-7936-4043-9936-c6c12c96f263"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Definition of the right multiplication", "Subsection",
 CellChangeTimes->{{3.85511934455542*^9, 3.8551193508428297`*^9}, {
  3.8551200533173485`*^9, 
  3.8551200539902916`*^9}},ExpressionUUID->"bcddd838-e3b3-4644-a386-\
c8490b706451"],

Cell["\<\
The aim is to be able to find the bounded operator on the Hilbert space that \
corresponds to right multiplication by a matrix D. This bounded operator \
takes the form of a matrix with respect to the standard basis. We will find \
this matrix by writing down a system of linear equations that it must \
satisfy, and then solving this system of equations.\
\>", "Text",
 CellChangeTimes->{{3.8551193655243025`*^9, 3.855119528844592*^9}, {
  3.8551200576861973`*^9, 
  3.8551200675419283`*^9}},ExpressionUUID->"78274f97-651d-4788-9cc4-\
a037559b8fa0"],

Cell[TextData[{
 "The options that are needed to check that the right multiplication matrix \
acts correctly. In other words: ",
 StyleBox["#1", "Input"],
 " and ",
 StyleBox["#2", "Input"],
 " play the role of A and B in A\[TensorProduct]B, and for every combination \
in ",
 StyleBox["RMoptions", "Input"],
 " we require that the left multiplication matrix acts as expected."
}], "Text",
 CellChangeTimes->{{3.8551195659000454`*^9, 3.855119683462344*^9}, {
  3.8551200726287746`*^9, 
  3.8551200797544403`*^9}},ExpressionUUID->"4c62fff7-a12a-42a0-9275-\
2d155b79f5f8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RMoptions", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Outer", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2"}], "}"}], "&"}], ",", "matrbasis", ",", 
       "matrbasis", ",", "1"}], "]"}], ",", "1"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851156997207614*^9, 3.8511570041948023`*^9}, 
   3.855119710301996*^9, 3.855120089381242*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"db2bc990-1e32-44ad-bee8-901f6ea01e71"],

Cell["\<\
The general matrix that acts as the right multiplication. We will solve the \
system of equations for this matrix. \
\>", "Text",
 CellChangeTimes->{{3.8551197493701153`*^9, 3.855119802516252*^9}, {
  3.8551201603737316`*^9, 
  3.8551201608363333`*^9}},ExpressionUUID->"0457839c-5b96-4d37-b10e-\
d0cb7e9b7b67"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RMmatr", "=", 
   RowBox[{"Array", "[", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"81", ",", "81"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851157563935605*^9, 3.8511575641035213`*^9}, 
   3.8551198140192633`*^9, {3.8551200920529685`*^9, 3.855120092997567*^9}, {
   3.8551418723890114`*^9, 3.8551418753409495`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"e761022c-f01c-4f7e-9235-a3bedd728616"],

Cell[TextData[{
 "The equations that ",
 StyleBox["RMmatr", "Input"],
 " must satisfy."
}], "Text",
 CellChangeTimes->{{3.855119818198496*^9, 3.855119830020871*^9}, 
   3.855120165604515*^9},ExpressionUUID->"0737d81b-4821-40e9-997a-\
352056b36b45"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RMeqs", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"KroneckerProduct", "[", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ".", "genmatd"}]}], "]"}], 
           ")"}], "//", "Flatten"}], ")"}], "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"RMmatr", ".", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"KroneckerProduct", "[", 
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "//", "Flatten"}],
                "}"}], "//", "Transpose"}], ")"}]}], ")"}], "//", "Flatten"}],
          ")"}]}], "==", "0"}], ")"}], "&"}], "/@", "RMoptions"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8511576530711184`*^9, 3.8511576624787693`*^9}, 
   3.8551198457891626`*^9, {3.85511989555723*^9, 3.855119899832492*^9}, {
   3.8551201718640757`*^9, 3.855120184553005*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"6810ccde-4e0b-44cb-b90e-1a32ae1980f8"],

Cell[TextData[{
 "Now we solve the system of linear equations to express ",
 StyleBox["RMmatr", "Input"],
 " in terms of ",
 StyleBox["genmatd.", "Input"]
}], "Text",
 CellChangeTimes->{{3.8551199082052803`*^9, 3.855119953221135*^9}, {
  3.8551201892200174`*^9, 
  3.8551201954474335`*^9}},ExpressionUUID->"fbae81d4-eac9-4c61-9471-\
f63a625b6878"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"RMans", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{"RMeqs", ",", 
     RowBox[{"RMmatr", "//", "Flatten"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RMmatrSol", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"RMmatr", "/.", "RMans"}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8511577351622133`*^9, 3.851157748168078*^9}, {
   3.851157786524358*^9, 3.851157796788237*^9}, 3.852093972930359*^9, {
   3.855119975380973*^9, 3.8551199943279514`*^9}, {3.8551336786658897`*^9, 
   3.8551337002067137`*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"95915d12-0434-415f-814f-f3420ebf8192"],

Cell[TextData[{
 "We can now use this matrix, ",
 StyleBox["RMmatrSol", "Input"],
 ", to define the left multiplication."
}], "Text",
 CellChangeTimes->{{3.8551200016352673`*^9, 3.855120023059656*^9}, 
   3.855133720697439*^9},ExpressionUUID->"14f10a3c-79eb-4b13-87de-\
322bef16712a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RM", "[", 
    RowBox[{"vec_", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a11_", ",", "a12_", ",", "a13_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a21_", ",", "a22_", ",", "a23_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a31_", ",", "a32_", ",", "a33_"}], "}"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"RMmatrSol", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"d", "[", 
          RowBox[{"1", ",", "1"}], "]"}], "->", "a11"}], ",", 
        RowBox[{
         RowBox[{"d", "[", 
          RowBox[{"1", ",", "2"}], "]"}], "->", "a12"}], ",", 
        RowBox[{
         RowBox[{"d", "[", 
          RowBox[{"1", ",", "3"}], "]"}], "->", "a13"}], ",", 
        RowBox[{
         RowBox[{"d", "[", 
          RowBox[{"2", ",", "1"}], "]"}], "->", "a21"}], ",", 
        RowBox[{
         RowBox[{"d", "[", 
          RowBox[{"2", ",", "2"}], "]"}], "->", "a22"}], ",", 
        RowBox[{
         RowBox[{"d", "[", 
          RowBox[{"2", ",", "3"}], "]"}], "->", "a23"}], ",", 
        RowBox[{
         RowBox[{"d", "[", 
          RowBox[{"3", ",", "1"}], "]"}], "->", "a31"}], ",", 
        RowBox[{
         RowBox[{"d", "[", 
          RowBox[{"3", ",", "2"}], "]"}], "->", "a32"}], ",", 
        RowBox[{
         RowBox[{"d", "[", 
          RowBox[{"3", ",", "3"}], "]"}], "->", "a33"}]}], "}"}]}], ")"}], 
    ".", "vec"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851157888053591*^9, 3.851157898599275*^9}, {
  3.855120030166478*^9, 3.855120036600398*^9}, {3.8551336964275265`*^9, 
  3.8551337148899856`*^9}, {3.8551343637194653`*^9, 3.8551343679366236`*^9}, {
  3.855141915260054*^9, 3.85514194046975*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"87864ad8-c115-4b86-b60f-3103134a52e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The equations for being a left *-homomorphism", "Subsection",
 CellChangeTimes->{{3.8551337687321205`*^9, 
  3.8551337886803603`*^9}},ExpressionUUID->"e71c747c-8e01-4ba6-b529-\
96c48b90c389"],

Cell[TextData[{
 "We will now construct the equations that ",
 StyleBox["HSinprmatr", "Input"],
 " must satisfy to make sure that the left multiplication is a \
*-homomorphism. Note that due to linearity these equations are also a \
sufficient condition for the left multiplication to be a *-homomorphism."
}], "Text",
 CellChangeTimes->{{3.855133806313858*^9, 3.855133850875146*^9}, {
   3.855133893402805*^9, 3.855133930908004*^9}, 
   3.855134286258767*^9},ExpressionUUID->"3e12865f-c4c4-4767-a3c5-\
b16e545a0b0a"],

Cell[TextData[{
 "We again start by creating the necessary list of options. In this case #1, \
#2 and #3 play the role of A, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["V", "1"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "c7b37d70-264b-4756-a15c-86b6a23f2571"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["V", "2"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "609e3e78-81d0-499b-b570-b55ab74c1c7d"],
 " in the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"<", 
     RowBox[{
      SuperscriptBox["A", "*"], " ", 
      SubscriptBox["V", "2"]}]}], ",", 
    RowBox[{
     SubscriptBox["V", "1"], ">"}]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "414223a3-fe7d-433e-b70f-127f6b38adbc"],
 " = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"<", 
     SubscriptBox["V", "2"]}], ",", 
    RowBox[{
     RowBox[{"A", " ", 
      SubscriptBox["V", "1"]}], ">"}]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "0e629363-ec59-4af2-818b-5b8e9dd2e7a6"],
 ", respectively."
}], "Text",
 CellChangeTimes->{{3.8551339438181934`*^9, 3.8551341504119096`*^9}, {
  3.8551342147524185`*^9, 3.855134248065197*^9}, {3.855134415558236*^9, 
  3.8551344225814676`*^9}},ExpressionUUID->"b0d82292-02d8-4152-b1aa-\
92fb3ec21d45"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lstarhomoptions", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Outer", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2", ",", "#3"}], "}"}], "&"}], ",", "matrbasis",
        ",", "HSbasis", ",", "HSbasis", ",", "1"}], "]"}], ",", "2"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8511586012527847`*^9, 3.85115861854813*^9}, {
  3.855134258754239*^9, 3.855134264274728*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"fac84332-d6d2-4e0b-8089-891f740d3293"],

Cell[TextData[{
 "Now we can give the equations that ",
 StyleBox["HSinprmatr", "Input"],
 " must satisfy."
}], "Text",
 CellChangeTimes->{{3.8551342719275956`*^9, 
  3.855134293826191*^9}},ExpressionUUID->"e85f00f5-c6e6-40f6-925d-\
a18396e8428a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lstarhomeqs", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Tr", "[", 
        RowBox[{
         RowBox[{"CT", "[", 
          RowBox[{"LM", "[", 
           RowBox[{
            RowBox[{"CT", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], ".", 
         "HSinprmatr", ".", 
         RowBox[{"#", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"Tr", "[", 
        RowBox[{
         RowBox[{"CT", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], ".", "HSinprmatr", ".", 
         RowBox[{"LM", "[", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "]"}]}], "==", "0"}], 
     "&"}], "/@", "Lstarhomoptions"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851158690587137*^9, 3.8511587116866603`*^9}, {
  3.851158835876772*^9, 3.8511588407014556`*^9}, {3.855134302294086*^9, 
  3.8551343182584143`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"f9e6d247-ca53-4729-91b9-a421d9fc8a7e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The equations for being a right *-homomorphism", "Subsection",
 CellChangeTimes->{{3.8551337687321205`*^9, 3.8551337886803603`*^9}, {
  3.8551343509955673`*^9, 
  3.8551343514715137`*^9}},ExpressionUUID->"58aee372-41d3-46d7-98b3-\
609f9233b5fe"],

Cell[TextData[{
 "We will now construct the equations that ",
 StyleBox["HSinprmatr", "Input"],
 " must satisfy to make sure that the right multiplication is a \
*-homomorphism. Note that due to linearity these equations are also a \
sufficient condition for the right multiplication to be a *-homomorphism."
}], "Text",
 CellChangeTimes->{{3.855133806313858*^9, 3.855133850875146*^9}, {
   3.855133893402805*^9, 3.855133930908004*^9}, 3.855134286258767*^9, {
   3.855134354083112*^9, 
   3.8551343846401367`*^9}},ExpressionUUID->"a14a0ba9-8b53-420c-ba5e-\
cad2dca21c40"],

Cell[TextData[{
 "We again start by creating the necessary list of options. In this case #1, \
#2 and #3 play the role of A, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["V", "1"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "046b05cd-94d0-411b-8b4c-a19de15b71a0"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["V", "2"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "4f710a4b-0743-4410-9ac1-08012a37bb39"],
 " in the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"<", 
     RowBox[{
      SubscriptBox["V", "2"], 
      SuperscriptBox["A", "*"]}]}], ",", 
    RowBox[{
     SubscriptBox["V", "1"], ">"}]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "9bb235ff-9f70-42f6-b980-48fe617430df"],
 " = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"<", 
     SubscriptBox["V", "2"]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["V", "1"], "A"}], ">"}]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "c1ca4460-cb8d-481e-933f-33d0e9c3977d"],
 ", respectively."
}], "Text",
 CellChangeTimes->{{3.8551339438181934`*^9, 3.8551341504119096`*^9}, {
  3.8551342147524185`*^9, 3.855134248065197*^9}, {3.8551343886454844`*^9, 
  3.8551343979739866`*^9}, {3.8551344340358067`*^9, 
  3.85513444493451*^9}},ExpressionUUID->"e40512fb-7c5d-49bf-9907-\
17f873b4f335"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Rstarhomoptions", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Outer", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2", ",", "#3"}], "}"}], "&"}], ",", "matrbasis",
        ",", "HSbasis", ",", "HSbasis", ",", "1"}], "]"}], ",", "2"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8511586012527847`*^9, 3.85115861854813*^9}, {
   3.855134258754239*^9, 3.855134264274728*^9}, 3.8551344521173296`*^9},
 CellLabel->"In[25]:=",ExpressionUUID->"ad87771b-7441-4e8b-a8d7-50ad4b1834ca"],

Cell[TextData[{
 "Now we can give the equations that ",
 StyleBox["HSinprmatr", "Input"],
 " must satisfy."
}], "Text",
 CellChangeTimes->{{3.8551342719275956`*^9, 
  3.855134293826191*^9}},ExpressionUUID->"b3d2a8f6-57e2-475f-ad94-\
d36631a67b35"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Rstarhomeqs", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Tr", "[", 
        RowBox[{
         RowBox[{"CT", "[", 
          RowBox[{"RM", "[", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"CT", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}], "]"}], ".", 
         "HSinprmatr", ".", 
         RowBox[{"#", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"Tr", "[", 
        RowBox[{
         RowBox[{"CT", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], ".", "HSinprmatr", ".", 
         RowBox[{"RM", "[", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}], ",", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}]}], "==", "0"}], 
     "&"}], "/@", "Rstarhomoptions"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851158690587137*^9, 3.8511587116866603`*^9}, {
  3.851158835876772*^9, 3.8511588407014556`*^9}, {3.855134302294086*^9, 
  3.8551343182584143`*^9}, {3.8551344542146406`*^9, 3.8551344768352203`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"a56599f1-763d-4e04-8fa1-b69bb1ec236f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Definition of the generator", "Subsection",
 CellChangeTimes->{{3.8551348230581627`*^9, 
  3.855134827617784*^9}},ExpressionUUID->"efa09cc1-a4e2-4d27-aa49-\
f9076da03b91"],

Cell["\<\
We will now define our state, generator of the QMS and the derivation.\
\>", "Text",
 CellChangeTimes->{{3.8551348336332073`*^9, 3.855134846592671*^9}, {
  3.855134946051038*^9, 3.855134948931059*^9}, {3.855135215191131*^9, 
  3.855135220228402*^9}},ExpressionUUID->"e4af8aaa-79dd-4a5e-8ffd-\
43f959ffb327"],

Cell["The state is given by", "Text",
 CellChangeTimes->{{3.855134954386876*^9, 
  3.855134956609499*^9}},ExpressionUUID->"decaa98b-dd8c-4759-b4bc-\
7863aeddd247"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Rho]", "=", 
   RowBox[{
    RowBox[{"3", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Pi", "^", "2"}], "+", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}]}], ")"}]}], 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"Pi", "^", "2"}], ",", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}]}], "}"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851159516698737*^9, 3.8511595212899933`*^9}, {
  3.8511595667496686`*^9, 3.851159624677052*^9}, {3.8511596727370644`*^9, 
  3.85115969265024*^9}, {3.8511597838856235`*^9, 3.8511598577887945`*^9}, {
  3.851159914835535*^9, 3.851159945528454*^9}, {3.851160038378532*^9, 
  3.8511600517113876`*^9}, {3.855134854961104*^9, 3.8551348557279735`*^9}, {
  3.855134887283791*^9, 3.8551349000508246`*^9}, {3.855142131233755*^9, 
  3.8551421717470255`*^9}, {3.855142919252587*^9, 3.8551429276998634`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"ff896055-1965-4871-b660-c140d9f061f5"],

Cell["The variables defining the generator are", "Text",
 CellChangeTimes->{{3.855143210212406*^9, 
  3.85514322443651*^9}},ExpressionUUID->"afd8cf8a-c9ec-4750-828f-\
c2ff1b01b9f5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"yvars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"y", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ",", 
     RowBox[{"y", "[", 
      RowBox[{"1", ",", "3"}], "]"}], ",", 
     RowBox[{"y", "[", 
      RowBox[{"2", ",", "2"}], "]"}], ",", 
     RowBox[{"y", "[", 
      RowBox[{"2", ",", "3"}], "]"}], ",", 
     RowBox[{"y", "[", 
      RowBox[{"3", ",", "3"}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.855143226437831*^9, 3.855143240597402*^9}, {
  3.855230312662236*^9, 3.8552303333478775`*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"c25054f5-c7ad-48a9-8839-1fad71c4a40a"],

Cell[TextData[{
 "The pairs ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Omega]", "j"], ",", 
     SubscriptBox["V", "j"], ",", 
     SubscriptBox["y", "j"]}], "}"}], TraditionalForm]],ExpressionUUID->
  "a3135e25-9c19-4fc7-b320-d5da5af21a21"],
 " are given by"
}], "Text",
 CellChangeTimes->{{3.855134974498922*^9, 3.855135008817601*^9}, {
  3.855143076501502*^9, 
  3.8551430815570745`*^9}},ExpressionUUID->"472567ad-d540-4a09-8708-\
49fda316d42f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Vset", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"E", "^", "Pi"}], "/", "Pi"}], ")"}], "^", "2"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"y", "[", 
        RowBox[{"2", ",", "3"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Pi", "/", 
          RowBox[{"E", "^", "Pi"}]}], ")"}], "^", "2"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"y", "[", 
        RowBox[{"2", ",", "3"}], "]"}]}], "}"}], ",", " ", "\n", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pi", "^", "2"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"y", "[", 
        RowBox[{"1", ",", "2"}], "]"}]}], "}"}], ",", " ", "\n", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"y", "[", 
        RowBox[{"1", ",", "3"}], "]"}]}], "}"}], ",", " ", "\n", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Pi", "^", "2"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"y", "[", 
        RowBox[{"1", ",", "2"}], "]"}]}], "}"}], ",", " ", "\n", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{"2", "Pi"}], ")"}]}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"y", "[", 
        RowBox[{"1", ",", "3"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"y", "[", 
        RowBox[{"1", ",", "1"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"y", "[", 
        RowBox[{"2", ",", "2"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}]}], "}"}], ",", 
       RowBox[{"y", "[", 
        RowBox[{"3", ",", "3"}], "]"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8551350109879837`*^9, 3.8551350618135157`*^9}, {
  3.8551421801158032`*^9, 3.855142216111153*^9}, {3.8551429303724174`*^9, 
  3.8551429378120546`*^9}, {3.8551430055248575`*^9, 3.8551430201650534`*^9}, {
  3.855143090223529*^9, 3.8551431560690327`*^9}, {3.8552303364493227`*^9, 
  3.855230371619557*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"345f5efe-9aaa-4c8b-85c1-fbe1cbb5acea"],

Cell["The generator is now given by", "Text",
 CellChangeTimes->{{3.855135120691352*^9, 
  3.8551351261173615`*^9}},ExpressionUUID->"e1e81183-02fa-4dbd-b63d-\
2ae6f74ad89d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"L", "[", "a_", "]"}], ":=", 
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "3", "]"}], "]"}], 
       RowBox[{"Sqrt", "[", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"CT", "[", 
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], ".", 
          RowBox[{"Com", "[", 
           RowBox[{"a", ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"Com", "[", 
           RowBox[{
            RowBox[{"CT", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "a"}], "]"}], ".", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}]}], "&"}], "/@", "Vset"}],
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851159516698737*^9, 3.8511595212899933`*^9}, {
  3.8511595667496686`*^9, 3.851159624677052*^9}, {3.8511596727370644`*^9, 
  3.85115969265024*^9}, {3.8511597838856235`*^9, 3.8511598577887945`*^9}, {
  3.851159914835535*^9, 3.851159945528454*^9}, {3.851160038378532*^9, 
  3.8511600517113876`*^9}, {3.8551351331100855`*^9, 3.855135133347043*^9}, {
  3.8551431652540965`*^9, 3.8551431670452847`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"3cd95a53-bc9c-4251-9ed3-53fac54d4fb5"],

Cell["Lastly, the derivation is given by", "Text",
 CellChangeTimes->{{3.8551352295425606`*^9, 
  3.8551352339892154`*^9}},ExpressionUUID->"d2c19a91-66ef-4310-a062-\
56b676f31a21"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Delta]", "[", "a_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"KroneckerProduct", "[", 
        RowBox[{"a", ",", 
         RowBox[{"Id", "[", "3", "]"}]}], "]"}], "//", "Flatten"}], "}"}], "//",
      "Transpose"}], ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851159452979478*^9, 3.851159467316114*^9}, {
   3.855135238996583*^9, 3.8551352399936786`*^9}, 3.8551422222457514`*^9},
 CellLabel->"In[43]:=",ExpressionUUID->"ee79fe67-e37d-4b34-98ce-d9d16f92bca8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The equations for \[Delta] being a square root of the generator in the GNS \
case\
\>", "Subsection",
 CellChangeTimes->{{3.855135161189561*^9, 3.8551351977794156`*^9}, {
  3.855135243753627*^9, 
  3.8551352604684615`*^9}},ExpressionUUID->"965ad5bc-9840-48ba-9ebc-\
a5edc9d63d48"],

Cell[TextData[{
 "We can finally construct the final piece of the puzzle, namely the \
equations on ",
 StyleBox["HSinprmatr", "Input"],
 " that are equivalent to the derivation ",
 StyleBox["\[Delta]", "Input"],
 " being the square root of the generator of the QMS in the GNS case."
}], "Text",
 CellChangeTimes->{{3.855139670160948*^9, 
  3.8551397483823013`*^9}},ExpressionUUID->"0326d690-9793-47ce-b829-\
fdf8b1ec3830"],

Cell[TextData[{
 "Once again we start by generating a list of options. In this case #1 and #2 \
represent A and B in the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"<", 
     RowBox[{"\[Delta]", 
      RowBox[{"(", "B", ")"}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Delta]", "(", "A", ")"}], 
      SubscriptBox[">", "H"]}], " ", "=", " ", 
     RowBox[{"<", 
      RowBox[{"L", "(", "B", ")"}]}]}], ",", 
    RowBox[{"A", 
     SubscriptBox[">", "GNS"]}]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "df45901a-f6d3-400a-9760-27ccf70acc7d"],
 "."
}], "Text",
 CellChangeTimes->{{3.8551397798575*^9, 3.8551398482049484`*^9}, {
  3.8551398782529593`*^9, 
  3.855139976845752*^9}},ExpressionUUID->"3ff10e0a-a29e-4ee2-93e2-\
7e23586d437b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtoptionsGNS", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Outer", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2"}], "}"}], "&"}], ",", "matrbasis", ",", 
       "matrbasis", ",", "1"}], "]"}], ",", "1"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851159516698737*^9, 3.8511595212899933`*^9}, {
  3.8511595667496686`*^9, 3.851159624677052*^9}, {3.8511596727370644`*^9, 
  3.85115969265024*^9}, {3.8511597838856235`*^9, 3.8511598577887945`*^9}, {
  3.851159914835535*^9, 3.851159945528454*^9}, {3.851160038378532*^9, 
  3.8511600517113876`*^9}, {3.8551399913585143`*^9, 3.8551399920785923`*^9}, {
  3.855140097899212*^9, 3.855140098141672*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"9b71ae37-b97e-4c59-869e-6cda4665c242"],

Cell[TextData[{
 "The equations that ",
 StyleBox["HSinprmatr", "Input"],
 " must satisfy are then given by"
}], "Text",
 CellChangeTimes->{{3.8551399969452553`*^9, 
  3.8551400214378276`*^9}},ExpressionUUID->"517ef647-ee62-4579-ae4c-\
535d6aea47e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrteqsGNS", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"CT", "[", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "//", "\[Delta]"}], "]"}], ".", 
        "HSinprmatr", ".", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "//", "\[Delta]"}], ")"}]}], "]"}],
       "==", 
      RowBox[{"-", 
       RowBox[{"nTr", "[", 
        RowBox[{"\[Rho]", ".", 
         RowBox[{"CT", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ".", 
         RowBox[{"L", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}]}]}], "&"}], "/@", 
    "sqrtoptionsGNS"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851159516698737*^9, 3.8511595212899933`*^9}, {
   3.8511595667496686`*^9, 3.851159624677052*^9}, {3.8511596727370644`*^9, 
   3.85115969265024*^9}, {3.8511597838856235`*^9, 3.8511598577887945`*^9}, {
   3.851159914835535*^9, 3.851159945528454*^9}, {3.851160038378532*^9, 
   3.8511600517113876`*^9}, {3.8551400384778366`*^9, 3.855140068205907*^9}, {
   3.8551401007992277`*^9, 3.855140104462345*^9}, 3.855140576310954*^9, 
   3.855146587136894*^9},
 CellLabel->"In[45]:=",ExpressionUUID->"301d1f77-44bd-4200-a467-495e65f11413"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The solution for the inproduct in the GNS case", "Subsection",
 CellChangeTimes->{{3.8551401664824715`*^9, 
  3.855140173742346*^9}},ExpressionUUID->"5ef1be45-f08f-46b1-ae87-\
7f8a490ae79b"],

Cell[TextData[{
 "We can now solve the system of linear equations given by ",
 StyleBox["Lstarhomeqs", "Input"],
 ", ",
 StyleBox["Rstarhomeqs ", "Input"],
 "and ",
 StyleBox["sqrteqsGNS", "Input"],
 "."
}], "Text",
 CellChangeTimes->{{3.8551401835351424`*^9, 
  3.8551402281439333`*^9}},ExpressionUUID->"1eda3562-f034-450d-b5c5-\
03efefdd9e27"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"inprmatransGNS", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{"Lstarhomeqs", ",", "Rstarhomeqs", ",", "sqrteqsGNS"}], "]"}], 
     ",", 
     RowBox[{"Join", "[", 
      RowBox[{"HSinprvars", ",", "yvars"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851159516698737*^9, 3.8511595212899933`*^9}, {
  3.8511595667496686`*^9, 3.851159624677052*^9}, {3.8511596727370644`*^9, 
  3.85115969265024*^9}, {3.8511597838856235`*^9, 3.8511598577887945`*^9}, {
  3.851159914835535*^9, 3.851159945528454*^9}, {3.851160038378532*^9, 
  3.8511600517113876`*^9}, {3.8551402869155045`*^9, 3.855140381345539*^9}, {
  3.855142242129566*^9, 3.855142245905879*^9}, {3.8551432483724966`*^9, 
  3.855143272292522*^9}, {3.8551460836510787`*^9, 3.8551460863208838`*^9}, {
  3.855230061460729*^9, 3.8552300763231287`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"d12ceb1b-9aba-45a7-a5b1-4347c092dff3"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "svars", 
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"", 2,
    49, 2, 22265654648871611463, "Kernel 3"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.855144896053564*^9, 3.8552238209402747`*^9, 
  3.8552300892554455`*^9, 3.855230399473242*^9},
 CellLabel->
  "During evaluation of \
In[49]:=",ExpressionUUID->"f18f31d1-a7a5-43de-a697-104df04b9850"]
}, Open  ]],

Cell["\<\
The final entry of the solution gives the equation for the y-variables.\
\>", "Text",
 CellChangeTimes->{{3.8551433198778405`*^9, 
  3.855143365050131*^9}},ExpressionUUID->"eaac7895-8493-451f-9898-\
2098e4fcffbe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"inprmatransGNS", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.85514337762389*^9, 3.8551433838131924`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"d511f5c6-958c-44c0-baaf-fc51ff5269fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", 
   RowBox[{"3", ",", "3"}], "]"}], "\[Rule]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[Pi]"}]], "-", 
        SuperscriptBox["\[Pi]", "2"]}], ")"}], " ", 
      RowBox[{"y", "[", 
       RowBox[{"1", ",", "1"}], "]"}]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[Pi]", "2"]}]]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[Pi]"}]], "+", 
       SuperscriptBox["\[Pi]", "2"]}], ")"}], " ", 
     RowBox[{"y", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "\[Pi]"], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "\[Pi]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[Pi]"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[Pi]"}]], "-", 
       SuperscriptBox["\[Pi]", "2"]}], ")"}], " ", 
     RowBox[{"y", "[", 
      RowBox[{"1", ",", "3"}], "]"}]}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[Pi]", "2"]}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[Pi]"}]]}], ")"}], " ", 
     RowBox[{"y", "[", 
      RowBox[{"2", ",", "2"}], "]"}]}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[Pi]", "2"]}]], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "\[Pi]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[Pi]"}]]}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"4", " ", "\[Pi]"}]], "+", 
       SuperscriptBox["\[Pi]", "2"], "-", 
       SuperscriptBox["\[Pi]", "4"]}], ")"}], " ", 
     RowBox[{"y", "[", 
      RowBox[{"2", ",", "3"}], "]"}]}], 
    RowBox[{"\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[Pi]", "2"]}], ")"}]}]]}]}]], "Output",
 CellChangeTimes->{3.855144896173876*^9, 3.855230089436103*^9, 
  3.855230399570459*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"67a40d7d-78fc-424d-bb4d-3b4eb97a50e2"]
}, Open  ]],

Cell["\<\
We conclude by checking that this equation corresponds to the one in the paper\
\>", "Text",
 CellChangeTimes->{{3.85523020054192*^9, 
  3.8552302317972784`*^9}},ExpressionUUID->"7ac8b6ba-75df-42ad-8ec4-\
99cc1a05741b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"\[Lambda]3", "^", "2"}], "-", 
          RowBox[{"\[Lambda]2", "^", "2"}]}], ")"}], 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Lambda]3", "^", "2"}], "-", 
            RowBox[{"\[Lambda]2", "^", "2"}]}], ")"}], "/", "\[Lambda]3"}], 
         "/", "\[Lambda]2"}], "*", 
        RowBox[{"y", "[", 
         RowBox[{"2", ",", "3"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Lambda]3", "^", "2"}], "-", "1", "-", 
          RowBox[{"\[Lambda]2", "^", "2"}]}], ")"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Lambda]2", "^", "2"}], "-", "1"}], ")"}], "/", 
         "\[Lambda]2"}], "*", 
        RowBox[{"y", "[", 
         RowBox[{"1", ",", "2"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Lambda]2", "^", "2"}], "-", "1", "-", 
          RowBox[{"\[Lambda]3", "^", "2"}]}], ")"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Lambda]3", "^", "2"}]}], ")"}], "/", "\[Lambda]3"}], 
        "*", 
        RowBox[{"y", "[", 
         RowBox[{"1", ",", "3"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"\[Lambda]3", "^", "2"}]}], ")"}], 
        RowBox[{"y", "[", 
         RowBox[{"2", ",", "2"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Lambda]3", "^", "2"}], "-", 
          RowBox[{"\[Lambda]2", "^", "2"}]}], ")"}], 
        RowBox[{"y", "[", 
         RowBox[{"1", ",", "1"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Lambda]2", "^", "2"}], "-", "1"}], ")"}], 
        RowBox[{"y", "[", 
         RowBox[{"3", ",", "3"}], "]"}]}]}], ")"}], "/.", 
     RowBox[{"\[Lambda]2", "->", "Pi"}]}], "/.", 
    RowBox[{"\[Lambda]3", "->", 
     RowBox[{"E", "^", "Pi"}]}]}], "/.", 
   RowBox[{"inprmatransGNS", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.8552302405932703`*^9, 3.8552302950722046`*^9}, {
  3.855230447863093*^9, 3.855230519888207*^9}, {3.855230561087344*^9, 
  3.8552307347701344`*^9}, {3.855234349121441*^9, 3.8552343650505114`*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"ebf79de0-8aa1-4057-b37b-057846c2faee"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.8552307037048593`*^9, 3.8552307356070924`*^9, 
  3.855234366553606*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"e20615b4-b78d-4be5-8d50-d42e4df89ee1"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Evaluator->"Kernel 3",
WindowSize->{717.75, 741.},
WindowMargins->{{-724.5, Automatic}, {228.5, Automatic}},
TaggingRules->Association["TryRealOnly" -> False],
CellContext->Notebook,
FrontEndVersion->"12.3 for Microsoft Windows (64-bit) (July 9, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c994096d-0cb0-432f-8a7b-ea854c56b521"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 192, 3, 53, "Subtitle",ExpressionUUID->"18dee504-3c88-454d-ba0e-aac5e649336b"],
Cell[775, 27, 201, 3, 35, "Text",ExpressionUUID->"e02fb853-9fcd-4f3a-b335-6b2525cab164"],
Cell[CellGroupData[{
Cell[1001, 34, 173, 3, 54, "Subsection",ExpressionUUID->"f3ffe692-ec71-4f9d-a372-9b7b78d5a6f3"],
Cell[1177, 39, 180, 3, 35, "Text",ExpressionUUID->"d4f1eecf-e9d7-42f8-b3ea-033e8677efa5"],
Cell[1360, 44, 219, 5, 28, "Input",ExpressionUUID->"487ea45d-740b-424b-894e-05ba763424af"],
Cell[1582, 51, 175, 3, 35, "Text",ExpressionUUID->"6bb6a308-7e02-43c4-bd10-1ff2372e73b3"],
Cell[1760, 56, 278, 8, 28, "Input",ExpressionUUID->"cbf9c7cd-e94e-4f8f-98fb-3ff1ca72da63"],
Cell[2041, 66, 172, 3, 35, "Text",ExpressionUUID->"4458f5f6-4213-4e2c-9548-4ef1b76e3a4f"],
Cell[2216, 71, 223, 5, 28, "Input",ExpressionUUID->"7e26f595-1fd5-488c-8c69-0b86d7305957"],
Cell[2442, 78, 164, 3, 35, "Text",ExpressionUUID->"09b14602-1d1d-478e-b2ff-55790d1c215c"],
Cell[2609, 83, 277, 7, 28, "Input",ExpressionUUID->"44417259-50eb-4f15-ab64-65b781667c74"],
Cell[2889, 92, 223, 4, 35, "Text",ExpressionUUID->"f4acf89f-d229-45df-8028-b4b3c6f05cd9"],
Cell[3115, 98, 617, 16, 48, "Input",ExpressionUUID->"15c805d5-9f22-48e8-aeaa-eec79daafa99"],
Cell[3735, 116, 347, 7, 58, "Text",ExpressionUUID->"5066d5db-e14c-44f9-89a5-c36a017ac4c7"],
Cell[4085, 125, 1550, 39, 67, "Input",ExpressionUUID->"0d8cb758-558f-498b-a0c6-c821a5169e8a"],
Cell[5638, 166, 285, 8, 35, "Text",ExpressionUUID->"b0d17b38-0702-4b4e-8241-8040240d3690"],
Cell[5926, 176, 1157, 32, 67, "Input",ExpressionUUID->"0b0eed15-9c03-46f3-b867-6451b58b3135"],
Cell[7086, 210, 226, 4, 35, "Text",ExpressionUUID->"a922e8cd-dfdf-48c6-95a7-6e5d15918e6b"],
Cell[7315, 216, 397, 11, 28, "Input",ExpressionUUID->"a2e0ca3e-406c-4e79-914e-e1f12746ded2"],
Cell[7715, 229, 221, 5, 35, "Text",ExpressionUUID->"acc02c3b-6284-4797-b3c0-ec0f9ca75654"],
Cell[7939, 236, 745, 19, 48, "Input",ExpressionUUID->"3bdbc3ba-21b0-4688-a3b2-8ef94a67d56e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8721, 260, 186, 3, 54, "Subsection",ExpressionUUID->"1aed2868-64d9-4323-9550-36da5574f1e3"],
Cell[8910, 265, 506, 9, 104, "Text",ExpressionUUID->"43663ee0-dffb-4bb4-8a8f-6c9ab698115f"],
Cell[9419, 276, 516, 13, 81, "Text",ExpressionUUID->"ca957107-5c31-4b70-b227-2ab3e6b349e3"],
Cell[9938, 291, 498, 13, 28, "Input",ExpressionUUID->"210cd4f0-f685-4816-b4ec-b1ee8c36a310"],
Cell[10439, 306, 266, 6, 58, "Text",ExpressionUUID->"2f430c0d-0ed9-4336-a1b6-bf5e89e09863"],
Cell[10708, 314, 405, 9, 28, "Input",ExpressionUUID->"bbf4e3df-9847-4ed1-809b-bfdf8622dfab"],
Cell[11116, 325, 225, 7, 35, "Text",ExpressionUUID->"3409362d-ddfe-48bd-ac18-c2a5c45192ec"],
Cell[11344, 334, 1714, 46, 105, "Input",ExpressionUUID->"ee8fbcf6-c7f5-4ad0-ad05-a60396047180"],
Cell[13061, 382, 299, 9, 35, "Text",ExpressionUUID->"703e9b07-80a3-4e78-9a6a-07a8a3fe70a4"],
Cell[13363, 393, 688, 17, 48, "Input",ExpressionUUID->"402e35fe-a44a-4c40-81d2-9d3a0ec43db8"],
Cell[14054, 412, 261, 7, 35, "Text",ExpressionUUID->"55e86c29-d85e-48ca-ba1b-1b6592d65650"],
Cell[14318, 421, 1766, 50, 67, "Input",ExpressionUUID->"2b97d8a5-7936-4043-9936-c6c12c96f263"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16121, 476, 240, 4, 54, "Subsection",ExpressionUUID->"bcddd838-e3b3-4644-a386-c8490b706451"],
Cell[16364, 482, 560, 10, 104, "Text",ExpressionUUID->"78274f97-651d-4788-9cc4-a037559b8fa0"],
Cell[16927, 494, 570, 14, 81, "Text",ExpressionUUID->"4c62fff7-a12a-42a0-9275-2d155b79f5f8"],
Cell[17500, 510, 520, 13, 28, "Input",ExpressionUUID->"db2bc990-1e32-44ad-bee8-901f6ea01e71"],
Cell[18023, 525, 320, 7, 58, "Text",ExpressionUUID->"0457839c-5b96-4d37-b10e-d0cb7e9b7b67"],
Cell[18346, 534, 462, 10, 28, "Input",ExpressionUUID->"e761022c-f01c-4f7e-9235-a3bedd728616"],
Cell[18811, 546, 248, 7, 35, "Text",ExpressionUUID->"0737d81b-4821-40e9-997a-352056b36b45"],
Cell[19062, 555, 1444, 39, 86, "Input",ExpressionUUID->"6810ccde-4e0b-44cb-b90e-1a32ae1980f8"],
Cell[20509, 596, 347, 9, 35, "Text",ExpressionUUID->"fbae81d4-eac9-4c61-9471-f63a625b6878"],
Cell[20859, 607, 692, 17, 48, "Input",ExpressionUUID->"95915d12-0434-415f-814f-f3420ebf8192"],
Cell[21554, 626, 284, 7, 35, "Text",ExpressionUUID->"14f10a3c-79eb-4b13-87de-322bef16712a"],
Cell[21841, 635, 1860, 50, 67, "Input",ExpressionUUID->"87864ad8-c115-4b86-b60f-3103134a52e1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23738, 690, 197, 3, 54, "Subsection",ExpressionUUID->"e71c747c-8e01-4ba6-b529-96c48b90c389"],
Cell[23938, 695, 517, 10, 81, "Text",ExpressionUUID->"3e12865f-c4c4-4767-a3c5-b16e545a0b0a"],
Cell[24458, 707, 1339, 42, 58, "Text",ExpressionUUID->"b0d82292-02d8-4152-b1aa-92fb3ec21d45"],
Cell[25800, 751, 556, 14, 28, "Input",ExpressionUUID->"fac84332-d6d2-4e0b-8089-891f740d3293"],
Cell[26359, 767, 247, 7, 35, "Text",ExpressionUUID->"e85f00f5-c6e6-40f6-925d-a18396e8428a"],
Cell[26609, 776, 1286, 35, 67, "Input",ExpressionUUID->"f9e6d247-ca53-4729-91b9-a421d9fc8a7e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27932, 816, 251, 4, 54, "Subsection",ExpressionUUID->"58aee372-41d3-46d7-98b3-609f9233b5fe"],
Cell[28186, 822, 571, 11, 81, "Text",ExpressionUUID->"a14a0ba9-8b53-420c-ba5e-cad2dca21c40"],
Cell[28760, 835, 1381, 43, 58, "Text",ExpressionUUID->"e40512fb-7c5d-49bf-9907-17f873b4f335"],
Cell[30144, 880, 581, 14, 28, "Input",ExpressionUUID->"ad87771b-7441-4e8b-a8d7-50ad4b1834ca"],
Cell[30728, 896, 247, 7, 35, "Text",ExpressionUUID->"b3d2a8f6-57e2-475f-ad94-d36631a67b35"],
Cell[30978, 905, 1336, 35, 67, "Input",ExpressionUUID->"a56599f1-763d-4e04-8fa1-b69bb1ec236f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32351, 945, 177, 3, 54, "Subsection",ExpressionUUID->"efa09cc1-a4e2-4d27-aa49-f9076da03b91"],
Cell[32531, 950, 317, 6, 35, "Text",ExpressionUUID->"e4af8aaa-79dd-4a5e-8ffd-43f959ffb327"],
Cell[32851, 958, 163, 3, 35, "Text",ExpressionUUID->"decaa98b-dd8c-4759-b4bc-7863aeddd247"],
Cell[33017, 963, 1105, 25, 28, "Input",ExpressionUUID->"ff896055-1965-4871-b660-c140d9f061f5"],
Cell[34125, 990, 181, 3, 35, "Text",ExpressionUUID->"afd8cf8a-c9ec-4750-828f-c2ff1b01b9f5"],
Cell[34309, 995, 704, 19, 28, "Input",ExpressionUUID->"c25054f5-c7ad-48a9-8839-1fad71c4a40a"],
Cell[35016, 1016, 485, 15, 36, "Text",ExpressionUUID->"472567ad-d540-4a09-8708-49fda316d42f"],
Cell[35504, 1033, 5295, 136, 181, "Input",ExpressionUUID->"345f5efe-9aaa-4c8b-85c1-fbe1cbb5acea"],
Cell[40802, 1171, 173, 3, 35, "Text",ExpressionUUID->"e1e81183-02fa-4dbd-b63d-2ae6f74ad89d"],
Cell[40978, 1176, 1491, 38, 48, "Input",ExpressionUUID->"3cd95a53-bc9c-4251-9ed3-53fac54d4fb5"],
Cell[42472, 1216, 180, 3, 35, "Text",ExpressionUUID->"d2c19a91-66ef-4310-a062-56b676f31a21"],
Cell[42655, 1221, 563, 14, 28, "Input",ExpressionUUID->"ee79fe67-e37d-4b34-98ce-d9d16f92bca8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43255, 1240, 290, 7, 54, "Subsection",ExpressionUUID->"965ad5bc-9840-48ba-9ebc-a5edc9d63d48"],
Cell[43548, 1249, 423, 10, 81, "Text",ExpressionUUID->"0326d690-9793-47ce-b829-fdf8b1ec3830"],
Cell[43974, 1261, 795, 24, 58, "Text",ExpressionUUID->"3ff10e0a-a29e-4ee2-93e2-7e23586d437b"],
Cell[44772, 1287, 827, 17, 28, "Input",ExpressionUUID->"9b71ae37-b97e-4c59-869e-6cda4665c242"],
Cell[45602, 1306, 250, 7, 35, "Text",ExpressionUUID->"517ef647-ee62-4579-ae4c-535d6aea47e6"],
Cell[45855, 1315, 1396, 35, 58, "Input",ExpressionUUID->"301d1f77-44bd-4200-a467-495e65f11413"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47288, 1355, 196, 3, 54, "Subsection",ExpressionUUID->"5ef1be45-f08f-46b1-ae87-7f8a490ae79b"],
Cell[47487, 1360, 345, 11, 58, "Text",ExpressionUUID->"1eda3562-f034-450d-b5c5-03efefdd9e27"],
Cell[CellGroupData[{
Cell[47857, 1375, 965, 18, 58, "Input",ExpressionUUID->"d12ceb1b-9aba-45a7-a5b1-4347c092dff3"],
Cell[48825, 1395, 435, 10, 28, "Message",ExpressionUUID->"f18f31d1-a7a5-43de-a697-104df04b9850"]
}, Open  ]],
Cell[49275, 1408, 223, 5, 35, "Text",ExpressionUUID->"eaac7895-8493-451f-9898-2098e4fcffbe"],
Cell[CellGroupData[{
Cell[49523, 1417, 280, 6, 28, "Input",ExpressionUUID->"d511f5c6-958c-44c0-baaf-fc51ff5269fa"],
Cell[49806, 1425, 2548, 80, 124, "Output",ExpressionUUID->"67a40d7d-78fc-424d-bb4d-3b4eb97a50e2"]
}, Open  ]],
Cell[52369, 1508, 229, 5, 35, "Text",ExpressionUUID->"7ac8b6ba-75df-42ad-8ec4-99cc1a05741b"],
Cell[CellGroupData[{
Cell[52623, 1517, 2605, 74, 105, "Input",ExpressionUUID->"ebf79de0-8aa1-4057-b37b-057846c2faee"],
Cell[55231, 1593, 200, 3, 55, "Output",ExpressionUUID->"e20615b4-b78d-4be5-8d50-d42e4df89ee1"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

